////////////////////////////////////////////
////////////////////////////////////////////
////////////////////////////////////////////

//freak start
#include	"g_local.h"
#include	"p_laser.h"

/*-----------------------0-----------------
  SP_LaserSight
Added By Freak
  Create/remove the laser sight entity
-----------------------------------------*/

#define lss self->lasersight

void SP_LaserSight(edict_t *self) {

   vec3_t  start,forward,right,end;
   if (self->client->pers.spectator == SPECTATING) {
	  return;
    }
   if ( lss ) {
      G_FreeEdict(lss);
      lss = NULL;
      gi.cprintf(self, PRINT_HIGH, "lasersight off.");
      return;
   }

   gi.cprintf(self, PRINT_HIGH, "lasersight on.");

   AngleVectors (self->client->v_angle, forward, right, NULL);

   VectorSet(end,100 , 0, 0);
   G_ProjectSource (self->s.origin, end, forward, right, start);

   lss = G_Spawn ();
   lss->owner = self;
   lss->movetype = MOVETYPE_NOCLIP;
   lss->solid = SOLID_NOT;
   lss->classname = "lasersight";
//   lss->s.modelindex = gi.modelindex ("put/your/own/model/here.md2");
   lss->s.modelindex = gi.modelindex ("models/objects/gibs/sm_meat/tris.md2");
   lss->s.skinnum = 0;

   lss->s.renderfx |= RF_FULLBRIGHT;

   lss->think = LaserSightThink;
   lss->nextthink = level.time + 0.1;
}


/*---------------------------------------------
  LaserSightThink
Added By Freak
  Updates the sights position, angle, and shape
   is the lasersight entity
---------------------------------------------*/

void LaserSightThink (edict_t *self)
{
   vec3_t start,end,endp,offset;
   vec3_t forward,right,up;
   trace_t tr;
    if (self->client->pers.spectator == SPECTATING) {
	  return;
    }
   AngleVectors (self->owner->client->v_angle, forward, right, up);

   VectorSet(offset,24 , 6, self->owner->viewheight-7);
   G_ProjectSource (self->owner->s.origin, offset, forward, right, start);
   VectorMA(start,8192,forward,end);

   tr = gi.trace (start,NULL,NULL, end,self->owner,CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);

   if (tr.fraction != 1) {
      VectorMA(tr.endpos,-4,forward,endp);
      VectorCopy(endp,tr.endpos);
   }

   if ((tr.ent->svflags & SVF_MONSTER) || (tr.ent->client)){
      if ((tr.ent->takedamage) && (tr.ent != self->owner)) {
         self->s.skinnum = 1;
      }
   }
   else
      self->s.skinnum = 0;

   vectoangles(tr.plane.normal,self->s.angles);
   VectorCopy(tr.endpos,self->s.origin);

   gi.linkentity (self);
   self->nextthink = level.time + 0.1;
}

////////////////////////////////////////////
////////////////////////////////////////////
////////////////////////////////////////////
// place laser  freak added 
void Cmd_PlaceLaser (edict_t *ent)
{
	edict_t		*self,
				*grenade;

	vec3_t		forward,
				wallp;

	trace_t		tr;


	int		laser_colour[] = {
								0xf2f2f0f0,		// bright red
								0xd0d1d2d3,		// bright green
								0xf3f3f1f1,		// brigt blue
								0xdcdddedf,		// bright yellow
								0xe0e1e2e3		// bitty yellow strobe
                                0x80818283  // dark purple
                                0x70717273  // light blue
                                0x90919293  // different green
                                0xb0b1b2b3  // purple
                                0x40414243  // different red
                                0xe2e5e3e6  // orange
                                0xd0f1d3f3  // mixture
                                0xf2f3f0f1  // inner = red, outer = blue
                                0xf3f2f1f0  // inner = blue, outer = red
                                0xdad0dcd2  // inner = green, outer = yellow
                                0xd0dad2dc  // inner = yellow, outer = green
							};

    if (ent->client->pers.spectator == SPECTATING) {
		return;
    }
	// valid ent ?
  	if ((!ent->client) || (ent->health<=0))
	   return;

	// cells for laser ?
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("grenades"))] <= 5)
	{
 		gi.cprintf(ent, PRINT_HIGH, "Not enough grenades for laser.\n");
		return;
	}

	// Setup "little look" to close wall
	VectorCopy(ent->s.origin,wallp);         

	// Cast along view angle
	AngleVectors (ent->client->v_angle, forward, NULL, NULL);

	// Setup end point
	wallp[0]=ent->s.origin[0]+forward[0]*50;
	wallp[1]=ent->s.origin[1]+forward[1]*50;
	wallp[2]=ent->s.origin[2]+forward[2]*50;  

	// trace
	tr = gi.trace (ent->s.origin, NULL, NULL, wallp, ent, MASK_SOLID);

	// Line complete ? (ie. no collision)
	if (tr.fraction == 1.0)
	{
	 	gi.cprintf (ent, PRINT_HIGH, "Too far from wall.\n");
		return;
	}

	// Hit sky ?
	if (tr.surface)
		if (tr.surface->flags & SURF_SKY)
			return;

	// Ok, lets stick one on then ...
	gi.cprintf (ent, PRINT_HIGH, "Laser attached.\n");

	ent->client->pers.inventory[ITEM_INDEX(FindItem("grenades"))] -= 5;

    // -----------
	// Setup laser
	// -----------
	self = G_Spawn();

	self -> movetype		= MOVETYPE_NONE;
	self -> solid			= SOLID_NOT;
	self -> s.renderfx		= RF_BEAM|RF_TRANSLUCENT;
	self -> s.modelindex	= 1;			// must be non-zero
	self -> s.sound			= gi.soundindex ("world/laser.wav");
	self -> classname		= "laser_yaya";
	self -> s.frame			= 2;	// beam diameter
  	self -> owner			= self;
	self -> s.skinnum		= laser_colour[((int) (random() * 1000)) % 5];
  	self -> dmg				= LASER_DAMAGE;
	self -> think			= pre_target_laser_think;
	self -> delay			= level.time + LASER_TIME;

	// Set orgin of laser to point of contact with wall
	VectorCopy(tr.endpos,self->s.origin);

	// convert normal at point of contact to laser angles
	vectoangles(tr.plane.normal,self -> s.angles);

	// setup laser movedir (projection of laser)
	G_SetMovedir (self->s.angles, self->movedir);

	VectorSet (self->mins, -8, -8, -8);
	VectorSet (self->maxs, 8, 8, 8);

	// link to world
	gi.linkentity (self);

	// start off ...
	target_laser_off (self);

	// ... but make automatically come on
	self -> nextthink = level.time + 2;
    grenade = G_Spawn();

	VectorClear (grenade->mins);
	VectorClear (grenade->maxs);
	VectorCopy (tr.endpos, grenade->s.origin);
	vectoangles(tr.plane.normal,grenade -> s.angles);

	grenade -> movetype		= MOVETYPE_NONE;
	grenade -> clipmask		= MASK_SHOT;
	grenade -> solid		= SOLID_NOT;
	grenade -> s.modelindex	= gi.modelindex ("models/objects/hglaser/tris.md2");
	grenade -> owner		= self;
	grenade -> nextthink	= level.time + LASER_TIME;
	grenade -> think		= G_FreeEdict;

	gi.linkentity (grenade);
}
 void	pre_target_laser_think (edict_t *self)
{
	target_laser_on (self);

	self->think = target_laser_think;
}

//freak end
////////////////////////////////////////////
////////////////////////////////////////////
////////////////////////////////////////////